/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.components;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import minecrafttransportsimulator.baseclasses.AnimationSwitchbox;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.RotationMatrix;
import minecrafttransportsimulator.entities.components.AEntityA_Base;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.entities.instances.EntityRadio;
import minecrafttransportsimulator.jsondefs.JSONCameraObject;
import minecrafttransportsimulator.jsondefs.JSONCollisionGroup;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperEntity;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketEntityRiderChange;
import minecrafttransportsimulator.sound.SoundInstance;
import minecrafttransportsimulator.systems.CameraSystem;

public abstract class AEntityB_Existing
extends AEntityA_Base {
    protected static final Point3D ZERO_FOR_CONSTRUCTOR = new Point3D();
    public final Point3D position;
    public final RotationMatrix orientation;
    public final Point3D prevPosition;
    public final RotationMatrix prevOrientation;
    public final Point3D motion;
    public final Point3D prevMotion;
    public double velocity;
    private static final Set<JSONCollisionGroup.CollisionType> boundingBoxCollisionTypes = new HashSet<JSONCollisionGroup.CollisionType>(Arrays.asList(JSONCollisionGroup.CollisionType.ATTACK, JSONCollisionGroup.CollisionType.CLICK));
    public final BoundingBox boundingBox;
    public IWrapperEntity rider;
    public boolean riderIsClient;
    public final List<JSONCameraObject> cameras = new ArrayList<JSONCameraObject>();
    public final Map<JSONCameraObject, AEntityD_Definable<?>> cameraEntities = new LinkedHashMap();
    public JSONCameraObject activeCamera;
    public AEntityD_Definable<?> activeCameraEntity;
    public AnimationSwitchbox activeCameraSwitchbox;
    private CameraSystem.CameraMode lastCameraMode;
    public final Point3D riderEyePosition = new Point3D();
    public final Point3D riderHeadPosition = new Point3D();
    public final Point3D riderCameraPosition = new Point3D();
    public final Point3D prevRiderCameraPosition = new Point3D();
    public RotationMatrix riderRelativeOrientation;
    public RotationMatrix prevRiderRelativeOrientation;
    private static final Point3D riderTempPoint = new Point3D();
    private static final RotationMatrix riderTempMatrix = new RotationMatrix();
    public int zoomLevel;
    public int cameraIndex;
    public boolean hasHeadTracking;
    public final Point3D headTrackingOrientation = new Point3D();
    public final EntityRadio radio;
    public List<SoundInstance> sounds = new ArrayList<SoundInstance>();

    public AEntityB_Existing(AWrapperWorld world, IWrapperNBT data) {
        super(world, data);
        if (data != null) {
            this.position = data.getPoint3d("position");
            this.orientation = new RotationMatrix().setToAngles(data.getPoint3d("angles"));
            this.motion = data.getPoint3d("motion");
            this.zoomLevel = data.getInteger("zoomLevel");
            this.cameraIndex = data.getInteger("cameraIndex");
        } else {
            this.position = new Point3D();
            this.orientation = new RotationMatrix();
            this.motion = new Point3D();
        }
        this.prevPosition = this.position.copy();
        this.prevOrientation = new RotationMatrix().set(this.orientation);
        this.prevMotion = this.motion.copy();
        this.boundingBox = new BoundingBox(this.shouldLinkBoundsToPosition() ? this.position : this.position.copy(), 0.5, 0.5, 0.5, boundingBoxCollisionTypes);
        if (this.hasRadio()) {
            this.radio = data != null ? new EntityRadio(this, data.getData("radio")) : new EntityRadio(this, null);
            world.addEntity(this.radio);
        } else {
            this.radio = null;
        }
    }

    public AEntityB_Existing(AWrapperWorld world, Point3D position, Point3D motion, Point3D angles) {
        super(world, null);
        this.position = position.copy();
        this.orientation = new RotationMatrix().setToAngles(angles);
        this.prevPosition = position.copy();
        this.prevOrientation = new RotationMatrix().set(this.orientation);
        this.motion = motion.copy();
        this.prevMotion = motion.copy();
        this.boundingBox = new BoundingBox(this.shouldLinkBoundsToPosition() ? this.position : this.position.copy(), 0.5, 0.5, 0.5, boundingBoxCollisionTypes);
        this.radio = null;
    }

    @Override
    public void update() {
        super.update();
        this.world.beginProfiling("EntityB_Level", true);
        if (this.world.isClient()) {
            this.updateSounds(0.0f);
        }
        if (this.requiresDeltaUpdates()) {
            this.prevPosition.set(this.position);
            this.prevMotion.set(this.motion);
            this.prevOrientation.set(this.orientation);
            this.velocity = this.motion.length();
        }
        if (this.cameraIndex != 0 && this.ticksExisted >= 5L) {
            this.activeCamera = null;
            while (this.cameraIndex != 0 && this.activeCamera == null) {
                if (this.cameraIndex - 1 < this.cameras.size()) {
                    this.activeCamera = this.cameras.get(this.cameraIndex - 1);
                    this.activeCameraEntity = this.cameraEntities.get(this.activeCamera);
                    this.activeCameraSwitchbox = this.activeCameraEntity.cameraSwitchboxes.get(this.activeCamera);
                    if (this.activeCameraSwitchbox == null || this.activeCameraSwitchbox.runSwitchbox(0.0f, false)) continue;
                    ++this.cameraIndex;
                    this.activeCamera = null;
                    continue;
                }
                this.cameraIndex = 0;
                this.activeCamera = null;
                if (this.lastCameraMode == null || !this.world.isClient() || !InterfaceManager.clientInterface.getClientPlayer().equals(this.rider)) continue;
                InterfaceManager.clientInterface.setCameraMode(this.lastCameraMode);
                this.lastCameraMode = null;
            }
            if (this.activeCamera != null && this.world.isClient() && InterfaceManager.clientInterface.getClientPlayer().equals(this.rider)) {
                if (this.lastCameraMode == null) {
                    this.lastCameraMode = InterfaceManager.clientInterface.getCameraMode();
                }
                if (InterfaceManager.clientInterface.getCameraMode() != CameraSystem.CameraMode.FIRST_PERSON) {
                    InterfaceManager.clientInterface.setCameraMode(CameraSystem.CameraMode.FIRST_PERSON);
                }
            }
        }
        this.world.endProfiling();
    }

    @Override
    public void remove() {
        super.remove();
        if (this.world.isClient()) {
            if (this.radio != null) {
                this.radio.stop();
            }
            for (SoundInstance sound : this.sounds) {
                if (sound.soundDef == null || !sound.soundDef.looping) continue;
                sound.stopSound = true;
            }
        }
        if (this.rider != null) {
            this.removeRider();
        }
        if (this.radio != null) {
            this.radio.remove();
        }
    }

    @Override
    public double getMass() {
        return this.rider != null ? 100.0 : 0.0;
    }

    public boolean updateRider() {
        if (this.rider.isValid()) {
            this.rider.setPosition(this.position, false);
            this.rider.setVelocity(this.motion);
            this.prevRiderRelativeOrientation.set(this.riderRelativeOrientation);
            if (!this.hasHeadTracking) {
                this.riderRelativeOrientation.angles.y += (double)this.rider.getYawDelta();
                if (this.riderRelativeOrientation.angles.y > 180.0) {
                    this.riderRelativeOrientation.angles.y -= 360.0;
                    this.prevRiderRelativeOrientation.angles.y -= 360.0;
                } else if (this.riderRelativeOrientation.angles.y < -180.0) {
                    this.riderRelativeOrientation.angles.y += 360.0;
                    this.prevRiderRelativeOrientation.angles.y += 360.0;
                }
                float pitchDelta = this.rider.getPitchDelta();
                if (Math.abs(this.riderRelativeOrientation.angles.x + (double)pitchDelta) < 85.0) {
                    this.riderRelativeOrientation.angles.x += (double)pitchDelta;
                }
            } else {
                this.riderRelativeOrientation.angles.set(this.headTrackingOrientation);
            }
            this.riderRelativeOrientation.updateToAngles();
            riderTempMatrix.set(this.orientation).multiply(this.riderRelativeOrientation).convertToAngles();
            this.rider.setOrientation(riderTempMatrix);
            this.riderEyePosition.set(0.0, (this.rider.getEyeHeight() + this.rider.getSeatOffset()) * this.rider.getVerticalScale(), 0.0).rotate(this.orientation).add(this.position);
            this.riderHeadPosition.set(this.riderEyePosition);
            if (this.world.isClient()) {
                this.prevRiderCameraPosition.set(this.riderCameraPosition);
                CameraSystem.CameraMode cameraMode = InterfaceManager.clientInterface.getCameraMode();
                if (CameraSystem.activeCamera == null && cameraMode != CameraSystem.CameraMode.FIRST_PERSON) {
                    this.riderCameraPosition.set(this.riderEyePosition);
                    int zoomRequired = 4 + this.zoomLevel;
                    riderTempPoint.set(0.0, 0.0, cameraMode == CameraSystem.CameraMode.THIRD_PERSON ? (double)(-zoomRequired) : (double)zoomRequired).rotate(this.rider.getOrientation());
                    this.riderEyePosition.add(riderTempPoint);
                    int cameraZoomRequired = 4 - InterfaceManager.clientInterface.getCameraDefaultZoom() + this.zoomLevel;
                    if (zoomRequired != cameraZoomRequired) {
                        riderTempPoint.set(0.0, 0.0, cameraMode == CameraSystem.CameraMode.THIRD_PERSON ? (double)(-cameraZoomRequired) : (double)cameraZoomRequired).rotate(this.rider.getOrientation());
                        this.riderCameraPosition.add(riderTempPoint);
                    } else {
                        this.riderCameraPosition.add(riderTempPoint);
                    }
                } else {
                    this.riderCameraPosition.set(this.riderEyePosition);
                }
            }
            return true;
        }
        if (!this.world.isClient()) {
            this.removeRider();
        }
        return false;
    }

    public boolean setRider(IWrapperEntity newRider, boolean facesForwards) {
        if (this.rider != null) {
            return false;
        }
        this.rider = newRider;
        boolean bl = this.riderIsClient = this.world.isClient() && this.rider.equals(InterfaceManager.clientInterface.getClientPlayer());
        if (this.riderRelativeOrientation == null) {
            this.riderRelativeOrientation = new RotationMatrix();
            this.prevRiderRelativeOrientation = new RotationMatrix();
        }
        if (facesForwards) {
            this.riderRelativeOrientation.setToZero();
        } else {
            riderTempPoint.set(0.0, 0.0, 1.0).rotate(this.rider.getOrientation()).reOrigin(this.orientation);
            this.riderRelativeOrientation.setToVector(riderTempPoint, false);
        }
        this.riderRelativeOrientation.convertToAngles();
        this.prevRiderRelativeOrientation.set(this.riderRelativeOrientation);
        riderTempMatrix.set(this.orientation).multiply(this.riderRelativeOrientation).convertToAngles();
        this.rider.setOrientation(riderTempMatrix);
        this.rider.setPosition(this.position, false);
        this.rider.getYawDelta();
        this.rider.getPitchDelta();
        this.rider.setRiding(this);
        if (!this.world.isClient()) {
            InterfaceManager.packetInterface.sendToAllClients(new PacketEntityRiderChange(this, this.rider, facesForwards));
        }
        return true;
    }

    public void removeRider() {
        this.rider.setRiding(null);
        if (!this.world.isClient()) {
            InterfaceManager.packetInterface.sendToAllClients(new PacketEntityRiderChange(this, this.rider));
        }
        this.rider = null;
        this.riderIsClient = false;
    }

    public void getRiderInterpolatedOrientation(RotationMatrix store, double partialTicks) {
        store.interploate(this.prevRiderRelativeOrientation, this.riderRelativeOrientation, partialTicks);
    }

    public void destroy(BoundingBox box) {
        this.remove();
    }

    public boolean shouldSavePosition() {
        return true;
    }

    public boolean shouldLinkBoundsToPosition() {
        return true;
    }

    public boolean requiresDeltaUpdates() {
        return false;
    }

    public void getInterpolatedOrientation(RotationMatrix store, double partialTicks) {
        if (this.requiresDeltaUpdates()) {
            store.interploate(this.prevOrientation, this.orientation, partialTicks);
        } else {
            store.set(this.orientation);
        }
    }

    public boolean canCollideWith(AEntityB_Existing entityToCollide) {
        return false;
    }

    public boolean interact(IWrapperPlayer player) {
        return false;
    }

    public float getLightProvided() {
        return 0.0f;
    }

    public boolean shouldRenderBeams() {
        return false;
    }

    public boolean hasRadio() {
        return false;
    }

    public void updateSounds(float partialTicks) {
        if (this.radio != null && partialTicks == 0.0f) {
            this.radio.update();
        }
    }

    @Override
    public IWrapperNBT save(IWrapperNBT data) {
        super.save(data);
        if (this.shouldSavePosition()) {
            data.setPoint3d("position", this.position);
            data.setPoint3d("motion", this.motion);
            data.setPoint3d("angles", this.orientation.convertToAngles());
        }
        if (this.radio != null) {
            data.setData("radio", this.radio.save(InterfaceManager.coreInterface.getNewNBTWrapper()));
        }
        if (!this.cameras.isEmpty()) {
            data.setInteger("zoomLevel", this.zoomLevel);
            data.setInteger("cameraIndex", this.cameraIndex);
        }
        return data;
    }
}

